
IF EXISTS
(
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
		WHERE TABLE_NAME = 'PG_CRED' AND COLUMN_NAME = 'UUID'
		AND DATA_TYPE = 'varchar'
)
BEGIN

	ALTER TABLE dbo.PG_CRED DROP CONSTRAINT DF_PG_CRED_UUID ;	
	ALTER TABLE dbo.PG_CRED ALTER COLUMN UUID uniqueidentifier  NULL;
	ALTER TABLE dbo.PG_CRED ADD CONSTRAINT
		DF_PG_CRED_UUID DEFAULT NEWID() FOR UUID;
END
go

IF NOT EXISTS
(
    SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PG_CRED' AND COLUMN_NAME = 'UUID'
)
BEGIN
	ALTER TABLE dbo.PG_CRED ADD
		UUID uniqueidentifier  NULL;

	ALTER TABLE dbo.PG_CRED ADD CONSTRAINT
		DF_PG_CRED_UUID DEFAULT NEWID() FOR UUID;
END